﻿using System.Collections.Generic;
using System.Windows;
using System.Windows.Media;

namespace Microscopic_Traffic_Simulator.Renderers
{
    /// <summary>
    /// Class for creating geometry with bezier curve from canvas-coordinated points.
    /// </summary>
    class BezierCurveGeometryCreator
    {
        /// <summary>
        /// Creates geometry with bezier curve from canvas-coordinated points.
        /// </summary>
        /// <param name="p1">Start point.</param>
        /// <param name="p2">End point.</param>
        /// <param name="c1">Start control point.</param>
        /// <param name="c2">End control point.</param>
        /// <returns>Path geometry with one Bezier curve.</returns>
        internal PathGeometry GetBezierCurveGeometry(Point p1, Point p2, Point c1, Point c2)
        {
            BezierSegment bezierSegment = new BezierSegment(c1, c2, p2, true);
            PathFigure pathFigure = new PathFigure(p1, new List<PathSegment>() { bezierSegment }, false);
            pathFigure.Freeze();
            PathGeometry geometry = new PathGeometry(new List<PathFigure>() { pathFigure });
            geometry.Freeze();
            return geometry;
        }
    }
}
